@extends('errors::illustrated-layout')

@section('title', 'Access Forbidden')
@section('code', '403')
@section('message', isset($exception) ? ($exception->getMessage() ?: "You don't have permission to access this resource.") : "You don't have permission to access this resource.")

@section('image')
<div class="relative">
    <!-- Access Denied Illustration -->
    <div class="inline-flex items-center justify-center w-48 h-48 rounded-full bg-gradient-to-br from-orange-500/20 to-red-500/20 border border-orange-500/30 mb-8 animate-float">
        <i data-lucide="shield-x" class="w-24 h-24 text-orange-400"></i>
    </div>

    <!-- Floating Security Elements -->
    <div class="absolute -top-4 -right-4 w-8 h-8 bg-orange-500 rounded-full animate-pulse opacity-60"></div>
    <div class="absolute -bottom-4 -left-4 w-6 h-6 bg-red-500 rounded-full animate-pulse opacity-40" style="animation-delay: 1s;"></div>
    <div class="absolute top-1/2 -left-8 w-4 h-4 bg-yellow-500 rounded-full animate-pulse opacity-50" style="animation-delay: 2s;"></div>

    <!-- Security Barrier Animation -->
    <div class="absolute inset-0 pointer-events-none">
        <svg class="w-full h-full opacity-20" viewBox="0 0 200 200">
            <!-- Barrier Lines -->
            <line x1="40" y1="40" x2="160" y2="40" stroke="url(#securityGradient)" stroke-width="3" opacity="0.8">
                <animate attributeName="opacity" values="0.4;0.8;0.4" dur="2s" repeatCount="indefinite"/>
            </line>
            <line x1="40" y1="80" x2="160" y2="80" stroke="url(#securityGradient)" stroke-width="3" opacity="0.6">
                <animate attributeName="opacity" values="0.4;0.8;0.4" dur="2s" repeatCount="indefinite" begin="0.3s"/>
            </line>
            <line x1="40" y1="120" x2="160" y2="120" stroke="url(#securityGradient)" stroke-width="3" opacity="0.8">
                <animate attributeName="opacity" values="0.4;0.8;0.4" dur="2s" repeatCount="indefinite" begin="0.6s"/>
            </line>
            <line x1="40" y1="160" x2="160" y2="160" stroke="url(#securityGradient)" stroke-width="3" opacity="0.6">
                <animate attributeName="opacity" values="0.4;0.8;0.4" dur="2s" repeatCount="indefinite" begin="0.9s"/>
            </line>
            <defs>
                <linearGradient id="securityGradient" x1="0%" y1="0%" x2="100%" y2="0%">
                    <stop offset="0%" style="stop-color:#F97316;stop-opacity:0.6" />
                    <stop offset="100%" style="stop-color:#EF4444;stop-opacity:0.6" />
                </linearGradient>
            </defs>
        </svg>
    </div>

    <!-- Status Message -->
    <div class="mt-8">
        <p class="text-gray-300 text-lg font-medium mb-4">Access Control</p>
        <div class="flex items-center justify-center gap-3 text-sm">
            <div class="flex items-center gap-2">
                <div class="w-3 h-3 bg-orange-500 rounded-full animate-pulse"></div>
                <span class="text-gray-400">Access Denied</span>
            </div>
            <div class="w-px h-4 bg-gray-600"></div>
            <div class="flex items-center gap-2">
                <i data-lucide="key" class="w-3 h-3 text-blue-400"></i>
                <span class="text-gray-400">Authentication Required</span>
            </div>
        </div>
    </div>
</div>
@endsection
