@extends('errors::illustrated-layout')

@section('title', 'Page Not Found')
@section('code', '404')
@section('message', "The page you're looking for doesn't exist or has been moved.")

@section('image')
<div class="relative">
    <!-- 404 Illustration -->
    <div class="inline-flex items-center justify-center w-48 h-48 rounded-full bg-gradient-to-br from-blue-500/20 to-purple-500/20 border border-blue-500/30 mb-8 animate-float">
        <i data-lucide="search-x" class="w-24 h-24 text-blue-400"></i>
    </div>

    <!-- Floating Elements -->
    <div class="absolute -top-4 -right-4 w-8 h-8 bg-blue-500 rounded-full animate-pulse opacity-60"></div>
    <div class="absolute -bottom-4 -left-4 w-6 h-6 bg-purple-500 rounded-full animate-pulse opacity-40" style="animation-delay: 1s;"></div>
    <div class="absolute top-1/2 -left-8 w-4 h-4 bg-cyan-500 rounded-full animate-pulse opacity-50" style="animation-delay: 2s;"></div>

    <!-- Animated Search Path -->
    <div class="absolute inset-0 pointer-events-none">
        <svg class="w-full h-full opacity-20" viewBox="0 0 200 200">
            <path d="M50,100 Q100,50 150,100 Q100,150 50,100" stroke="url(#searchGradient)" stroke-width="2" fill="none" class="animate-pulse">
                <animate attributeName="stroke-dasharray" values="0,1000;300,700;0,1000" dur="4s" repeatCount="indefinite"/>
            </path>
            <defs>
                <linearGradient id="searchGradient" x1="0%" y1="0%" x2="100%" y2="100%">
                    <stop offset="0%" style="stop-color:#3B82F6;stop-opacity:0.6" />
                    <stop offset="100%" style="stop-color:#8B5CF6;stop-opacity:0.6" />
                </linearGradient>
            </defs>
        </svg>
    </div>

    <!-- Status Message -->
    <div class="mt-8">
        <p class="text-gray-300 text-lg font-medium mb-4">Search Status</p>
        <div class="flex items-center justify-center gap-3 text-sm">
            <div class="flex items-center gap-2">
                <div class="w-3 h-3 bg-red-500 rounded-full animate-pulse"></div>
                <span class="text-gray-400">Not Found</span>
            </div>
            <div class="w-px h-4 bg-gray-600"></div>
            <div class="flex items-center gap-2">
                <i data-lucide="map" class="w-3 h-3 text-blue-400"></i>
                <span class="text-gray-400">Explore Sitemap</span>
            </div>
        </div>
    </div>
</div>
@endsection
