@extends('errors::illustrated-layout')

@section('title', 'Service Unavailable')
@section('code', '503')
@section('message', "We're temporarily down for maintenance. We'll be back online shortly.")

@section('image')
<div class="relative">
    <!-- Maintenance Illustration -->
    <div class="inline-flex items-center justify-center w-48 h-48 rounded-full bg-gradient-to-br from-yellow-500/20 to-orange-500/20 border border-yellow-500/30 mb-8 animate-float">
        <i data-lucide="settings" class="w-24 h-24 text-yellow-400 animate-spin" style="animation-duration: 3s;"></i>
    </div>

    <!-- Floating Maintenance Elements -->
    <div class="absolute -top-4 -right-4 w-8 h-8 bg-yellow-500 rounded-full animate-pulse opacity-60"></div>
    <div class="absolute -bottom-4 -left-4 w-6 h-6 bg-orange-500 rounded-full animate-pulse opacity-40" style="animation-delay: 1s;"></div>
    <div class="absolute top-1/2 -left-8 w-4 h-4 bg-amber-500 rounded-full animate-pulse opacity-50" style="animation-delay: 2s;"></div>

    <!-- Maintenance Progress Animation -->
    <div class="absolute inset-0 pointer-events-none">
        <svg class="w-full h-full opacity-20" viewBox="0 0 200 200">
            <!-- Progress Circle -->
            <circle cx="100" cy="100" r="80" stroke="url(#maintenanceGradient)" stroke-width="3" fill="none" stroke-dasharray="502" stroke-dashoffset="502" transform="rotate(-90 100 100)">
                <animate attributeName="stroke-dashoffset" values="502;125;502" dur="4s" repeatCount="indefinite"/>
            </circle>
            <defs>
                <linearGradient id="maintenanceGradient" x1="0%" y1="0%" x2="100%" y2="100%">
                    <stop offset="0%" style="stop-color:#F59E0B;stop-opacity:0.6" />
                    <stop offset="100%" style="stop-color:#F97316;stop-opacity:0.6" />
                </linearGradient>
            </defs>
        </svg>
    </div>

    <!-- Status Message -->
    <div class="mt-8">
        <p class="text-gray-300 text-lg font-medium mb-4">Maintenance Mode</p>
        <div class="flex items-center justify-center gap-3 text-sm">
            <div class="flex items-center gap-2">
                <div class="w-3 h-3 bg-yellow-500 rounded-full animate-pulse"></div>
                <span class="text-gray-400">Under Maintenance</span>
            </div>
            <div class="w-px h-4 bg-gray-600"></div>
            <div class="flex items-center gap-2">
                <i data-lucide="clock" class="w-3 h-3 text-blue-400"></i>
                <span class="text-gray-400">Estimated: 30 min</span>
            </div>
        </div>
    </div>
</div>
@endsection
