<?php $__env->startSection('title', 'Internal Server Error'); ?>
<?php $__env->startSection('code', '500'); ?>
<?php $__env->startSection('message', "We're experiencing technical difficulties. Our team has been notified and is working to resolve this issue."); ?>

<?php $__env->startSection('image'); ?>
<div class="relative">
    <!-- Server Error Illustration -->
    <div class="inline-flex items-center justify-center w-48 h-48 rounded-full bg-gradient-to-br from-red-500/20 to-orange-500/20 border border-red-500/30 mb-8 animate-float">
        <i data-lucide="server-crash" class="w-24 h-24 text-red-400"></i>
    </div>

    <!-- Floating Error Elements -->
    <div class="absolute -top-4 -right-4 w-8 h-8 bg-red-500 rounded-full animate-pulse opacity-60"></div>
    <div class="absolute -bottom-4 -left-4 w-6 h-6 bg-orange-500 rounded-full animate-pulse opacity-40" style="animation-delay: 1s;"></div>
    <div class="absolute top-1/2 -left-8 w-4 h-4 bg-yellow-500 rounded-full animate-pulse opacity-50" style="animation-delay: 2s;"></div>

    <!-- Error Circuit Animation -->
    <div class="absolute inset-0 pointer-events-none">
        <svg class="w-full h-full opacity-20" viewBox="0 0 200 200">
            <path d="M20,100 L60,100 L60,60 L140,60 L140,140 L180,140" stroke="url(#errorGradient)" stroke-width="2" fill="none" class="animate-pulse">
                <animate attributeName="stroke-dasharray" values="0,1000;200,800;0,1000" dur="3s" repeatCount="indefinite"/>
            </path>
            <circle cx="60" cy="100" r="4" fill="#EF4444" opacity="0.6">
                <animate attributeName="opacity" values="0.2;0.8;0.2" dur="2s" repeatCount="indefinite"/>
            </circle>
            <circle cx="140" cy="60" r="4" fill="#F97316" opacity="0.6">
                <animate attributeName="opacity" values="0.2;0.8;0.2" dur="2s" repeatCount="indefinite" begin="0.5s"/>
            </circle>
            <defs>
                <linearGradient id="errorGradient" x1="0%" y1="0%" x2="100%" y2="100%">
                    <stop offset="0%" style="stop-color:#EF4444;stop-opacity:0.6" />
                    <stop offset="100%" style="stop-color:#F97316;stop-opacity:0.6" />
                </linearGradient>
            </defs>
        </svg>
    </div>

    <!-- Status Message -->
    <div class="mt-8">
        <p class="text-gray-300 text-lg font-medium mb-4">Server Status</p>
        <div class="flex items-center justify-center gap-3 text-sm">
            <div class="flex items-center gap-2">
                <div class="w-3 h-3 bg-red-500 rounded-full animate-pulse"></div>
                <span class="text-gray-400">Error Detected</span>
            </div>
            <div class="w-px h-4 bg-gray-600"></div>
            <div class="flex items-center gap-2">
                <i data-lucide="tool" class="w-3 h-3 text-yellow-400"></i>
                <span class="text-gray-400">Auto-Recovery</span>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('errors::illustrated-layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\algotrade\resources\views/errors/500.blade.php ENDPATH**/ ?>